# SAAM Cabins - Porta Cabin Solutions Website

A modern, responsive website for SAAM Cabins built with Next.js 14, TypeScript, and Tailwind CSS. This project features a complete redesign matching the actual business - porta cabin manufacturing and supply across UAE.

## � Project Overview

SAAM Cabins is a leading porta cabin manufacturer and supplier based in UAE. This website showcases:

- **Business-Accurate Content**: Reflects actual porta cabin manufacturing business in UAE
- **Professional Design**: Clean, corporate design suitable for B2B clients
- **Performance Optimized**: Fast loading times and SEO optimization
- **Mobile Responsive**: Optimized for all devices and screen sizes
- **GoDaddy Compatible**: Configured for static export deployment

## 🚀 Features

### Current Implementation
- **Responsive Header & Navigation**: Professional navigation with product categories
- **Hero Section**: Clear messaging about porta cabin solutions
- **Product Showcase**: Office cabins, security cabins, toilet units portfolio
- **About Page**: Company information, manufacturing capabilities, quality standards
- **Contact Page**: UAE contact details, quote request form, business information
- **Work Portfolio**: Detailed showcase of different cabin types with specifications
- **Modern UI Components**: Built with shadcn/ui and Radix UI primitives
- **SEO Optimized**: Meta tags optimized for porta cabin industry

### Future Enhancements
- **Product Detail Pages**: Individual pages for each cabin type with detailed specifications
- **Quote System**: Interactive quote calculator based on requirements
- **Image Gallery**: High-quality photos of actual manufactured cabins
- **Customer Testimonials**: Case studies and client reviews
- **Installation Process**: Step-by-step guide of delivery and installation
- **Maintenance Services**: Information about after-sales support

## 🛠️ Technology Stack

- **Framework**: Next.js 14+ (App Router)
- **Language**: TypeScript
- **Styling**: Tailwind CSS
- **UI Components**: shadcn/ui + Radix UI
- **Icons**: Lucide React
- **Development**: ESLint, TypeScript strict mode
- **Deployment**: Static export for GoDaddy hosting

## 📁 Project Structure

```
src/
├── app/                    # Next.js App Router pages
│   ├── about/             # About page - company info and capabilities
│   ├── contact/           # Contact page - UAE location and quote form
│   ├── work/              # Portfolio page - cabin types showcase
│   ├── globals.css        # Global styles and Tailwind imports
│   ├── layout.tsx         # Root layout with header/footer
│   └── page.tsx           # Homepage - porta cabin solutions
├── components/            # React components
│   ├── ui/               # shadcn/ui components
│   ├── Header.tsx        # Navigation with UAE contact info
│   └── Footer.tsx        # Footer with company details
└── lib/                   # Utility functions
    └── utils.ts          # Tailwind class utilities
```

## 🚀 Getting Started

### Prerequisites
- Node.js 18+ 
- npm, yarn, pnpm, or bun

### Installation

1. **Clone and Setup**
   ```bash
   git clone <repository-url>
   cd new-saamcbins
   npm install
   ```

2. **Development Server**
   ```bash
   npm run dev
   ```
   Open [http://localhost:3000](http://localhost:3000) (or 3001 if port conflict exists)

3. **Build for Production**
   ```bash
   npm run build
   ```

## 🌐 Deployment

### GoDaddy Hosting
This project is configured for static export deployment on GoDaddy:

1. **Build Static Site**
   ```bash
   npm run build
   ```

2. **Upload to GoDaddy**
   - Upload contents of `dist/` folder to your GoDaddy public_html directory
   - Ensure all files maintain their directory structure

3. **Configuration Notes**
   - `output: 'export'` in next.config.ts enables static generation
   - `trailingSlash: true` ensures compatibility with static hosting
   - `images.unoptimized: true` allows images to work without Next.js server

### Environment Variables
Create `.env.local` for local development:

```env
# Future CMS Configuration
NEXT_PUBLIC_STRAPI_API_URL=http://localhost:1337
STRAPI_API_TOKEN=your_api_token_here

# Contact Form (if using external service)
NEXT_PUBLIC_CONTACT_FORM_URL=your_form_endpoint
```

## 🎨 Customization

### Brand Colors
Update Tailwind configuration in `tailwind.config.js`:

```javascript
theme: {
  extend: {
    colors: {
      'saam-green': '#166534',
      'saam-blue': '#1e40af',
      // Add your brand colors
    }
  }
}
```

### Content Management
Ready for Strapi CMS integration:

1. Set up Strapi backend
2. Configure API endpoints in `/lib/api.ts`
3. Update components to fetch dynamic content
4. Add environment variables for production

## 🔧 Development Commands

```bash
# Development
npm run dev          # Start development server
npm run build        # Build for production
npm run start        # Start production server
npm run lint         # Run ESLint

# Additional Commands
npm run type-check   # TypeScript type checking
npm run format       # Code formatting (if Prettier configured)
```

## 📱 Browser Support

- **Modern browsers**: Chrome 90+, Firefox 88+, Safari 14+, Edge 90+
- **Mobile**: iOS Safari 14+, Chrome Mobile 90+
- **Responsive**: Mobile-first design, works on all screen sizes

## 🤝 Contributing

1. Follow the existing code style and conventions
2. Use TypeScript for all new components
3. Implement responsive design patterns
4. Test across different screen sizes
5. Optimize images and performance

## 📄 License

This project is proprietary to SAAM Cabins. All rights reserved.

## 🔗 Links

- **Current Website**: [saamcabins.com](https://saamcabins.com)
- **Design System**: [shadcn/ui](https://ui.shadcn.com)
- **Framework**: [Next.js](https://nextjs.org)
- **Deployment**: [GoDaddy](https://www.godaddy.com)

---

**Note**: This is a development version. The production deployment will include additional features like CMS integration, booking system, and enhanced content management.
